import random
import time

def BucketSelection(array):
    if len(array) <= 1:
        return array

    # Mencari nilai maksimum dan minimum dalam array
    max_val = max(array)
    min_val = min(array)

    # Menentukan ukuran setiap range
    range_size = 10
    num_ranges = ((max_val - min_val) // range_size) + 1

    # Inisialisasi array kosong untuk setiap range
    ranges = [[] for i in range(num_ranges)]

    # Memasukkan setiap elemen ke dalam range yang sesuai
    for val in array:
        range_index = (val - min_val) // range_size
        ranges[range_index].append(val)

    # Memanggil selectionSort untuk setiap range
    sorted_ranges = []
    for i in range(num_ranges):
        sorted_range = selectionSortHybrid(ranges[i])
        sorted_ranges.extend(sorted_range)

    return sorted_ranges


def selectionSortHybrid(array):
    left = 0
    right = len(array) - 1
    while left < right:
        minIndex = left
        maxIndex = right
        for i in range(left, right + 1):
            if array[i] < array[minIndex]:
                minIndex = i
            if array[i] > array[maxIndex]:
                maxIndex = i
        array[left], array[minIndex] = array[minIndex], array[left]
        if left == maxIndex:
            maxIndex = minIndex
        array[right], array[maxIndex] = array[maxIndex], array[right]
        left += 1
        right -= 1
    return array

def selectionhybrid(arr):
    left = 0
    right = len(arr) - 1
    while (left < right):
        minIndex = left
        maxIndex = right
        for i in range(left, right):
            if (arr[i] < arr[minIndex]):
                minIndex = i
            if (arr[i] > arr[maxIndex]):
                maxIndex = i
        arr[left], arr[minIndex] = arr[minIndex], arr[left]
        if (left == maxIndex):
            maxIndex = minIndex
        arr[right], arr[maxIndex] = arr[maxIndex], arr[right]
        left += 1
        right -= 1
    return arr

def quickSort(array):
    if len(array) <= 1:
        return array
    else:
        pivot = array[0]
        less = [x for x in array[1:] if x <= pivot]
        greater = [x for x in array[1:] if x > pivot]
        return quickSort(less) + [pivot] + quickSort(greater)

n = int(input("Masukkan banyak angka acak: "))
arr = [random.randint(-n, n) for x in range(n)]

print (arr)

start = time.time()
selectionhybrid = selectionhybrid(arr[:])
end = time.time()
print("Waktu eksekusi Selection Hybrid:", end - start)

start = time.time()
BucketSelection = BucketSelection(arr[:])
end = time.time()
print("Waktu eksekusi BucketSort Selection Hybrid:", end - start)

start = time.time()
quickSort = quickSort(arr[:])
end = time.time()
print("Waktu eksekusi Quick Sort:", end - start)